package h.com.serialapp.activity

import android.os.Bundle
import android.support.v4.app.FragmentManager
import android.support.v4.app.FragmentTransaction
import android.widget.Toast
import h.com.serialapp.R
import h.com.serialapp.activity.fragment.*
import h.com.serialportapi.comn.SerialPortManager
import h.com.serialportapi.comn.message.IMessage
import h.com.serialportapi.comn.message.LogManager
import kotlinx.android.synthetic.main.activity_home.*
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode

/**
 * Created by hxd on 2018/10/21.
 */
class HomeActivity : BaseActivity() {

    lateinit var manager: FragmentManager
    lateinit var fragment: Array<BasesFragment>
    lateinit var current: BasesFragment
    lateinit var transaction: FragmentTransaction


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_home)
        init()
    }

    fun init() {
        fragment = arrayOf(ISO1444334(), Mifare_Classic(), Uitralight_C(), DesFire(), ISO14443B(), ISO15693())
        manager = supportFragmentManager
        transaction = manager.beginTransaction()
        transaction.add(R.id.Content, fragment[0])
        transaction.commit()
        current = fragment[0]
        rb01.isChecked = true
        rg01.setOnCheckedChangeListener { group, checkedId ->
            when (checkedId) {
                R.id.rb01 -> {
                    changeFragment(0)
                }
                R.id.rb02 -> {
                    changeFragment(1)
                }
                R.id.rb03 -> {
                    changeFragment(2)
                }
                R.id.rb04 -> {
                    changeFragment(3)
                }
                R.id.rb05 -> {
                    changeFragment(4)
                }
                R.id.rb06 -> {
                     changeFragment(5)
//                    Toast.makeText(this, "开发中敬请期待...", Toast.LENGTH_SHORT).show()
//                    rb01.isChecked = true
//                    changeFragment(0)
                }
            }

        }


    }

    public override fun onStart() {
        super.onStart()
        EventBus.getDefault().register(this)
    }

    public override fun onStop() {
        super.onStop()
        EventBus.getDefault().unregister(this)
    }

    /**
     * 切换Fragment
     */
    public fun changeFragment(postion: Int, vararg param: Any) {
        val fragment1 = fragment[postion]
        transaction = manager.beginTransaction()// 开始事物
        // transaction.replace(R.id.viewContainer, fragment);
        // transaction.commit();
        if (!fragment1.isAdded()) { // 先判断是否被add过
            transaction.hide(current).add(R.id.Content, fragment1).commit() // 隐藏当前的fragment，add下一个到Activity中
        } else {
            transaction.hide(current).show(fragment1).commit()
        }
        current = fragment1
        LogManager.instance().clear()
//        fragment1.onSwitch(param)
    }

//    @Subscribe(threadMode = ThreadMode.MAIN)
//    fun onMessageEvent(message: IMessage) {
//        // 收到时间，刷新界面
//        ada.add(message)
//    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    fun onMessageEvent(message: IMessage) {
        // 收到时间，刷新界面
        current.add(message)
    }

    override fun onDestroy() {
        SerialPortManager.instance().close()
        super.onDestroy()
    }
}